<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

abstract class XenCentral_AdServer_Locations_Hooks_Abstract_Forum extends XenCentral_AdServer_Locations_Hooks_Abstract
{
    protected $node_id_list;
public function getOptionTemplate()
    {
        return 'xcas_location_forum_hook';
    }

    public function prepareFromData($locationData)
    {
        $locationData = parent::prepareFromData($locationData);

        if (!empty($locationData['node_id_list'])) {
            $this->node_id_list = $locationData['node_id_list'];
        }

        return $locationData;
    }

    public function preCheck()
    {
        if (!parent::preCheck()) {
            return false;
        }
        if (empty($this->hook_params['forum'])
            OR empty($this->hook_params['forum']['node_id'])
        ) {
            // no post-specific check is possible, so if we have something specified, ad should not be shown
            return is_null($this->node_id_list);
        }

        foreach (array(
                     'node_id_list' => 'node_id',
                 ) AS $property => $value) {
            if ($this->$property AND !in_array($this->hook_params['forum'][$value], explode(',', $this->$property))) {
                return false;
            }
        }

        return true;
    }


}